program Pedidos ( FAlmacen, FPedidos, FClientes, Ftexto );
   uses Crt, Printer;
	type
		TCodProducto = 1..100;

		TDireccion = record
			Calle:     string[ 20 ];
			Ciudad:    string[ 20 ];
			Provincia: string[ 10 ];
		end;

		TProducto = record
			CodProducto: TCodProducto;   { Cdigo del producto }
			NomProducto: string[ 11 ]; { Nombre del producto }
			RefProducto: string[ 10 ]; { Referencia }
			Precio:      Integer;	   { Precio del producto }
			Minimo:      Integer;	   { Cantidad mnima permitida }
			Cantidad:    Integer;	   { Cantidad en el almacn }
			Proveedor:   string[ 30 ]; { Nombre del proveedor }
			Direccion:   TDireccion;   { Direccin del proveedor }
		end;

		TPedido = record
			CodProducto: TCodProducto; { Cdigo del producto }
			CodCliente:  Integer;    { Cdigo del cliente }
			Cantidad:    Integer;    { Cantidad solicitada }
		end;

		TCliente = record
		   NomCliente: string[ 30 ]; { Nombre del cliente }
			RefCliente: string[ 10 ]; { Referencia del cliente }
         Direccion:  TDireccion;   { Direccin del cliente }
		end;

		TFAlmacen =   file of TProducto;
		TFPedidos =   file of TPedido;
		TFClientes =  file of TCliente;
		TAProductos = array[ TCodProducto ] of TProducto;

	var
		FAlmacen:   TFAlmacen;
		FPedidos:   TFPedidos;
		FClientes:  TFClientes;
		AProductos: TAProductos;


	{ Procedimiento que inicializa el array que contiene la informacin de
	  los productos de los que consta el almacen. Inicializa el campo
	  " precio " de cada uno de los registros con el valor -1. }

	procedure InicializarMemoria ( var ArrayProductos: TAProductos );

		var
			Producto: TCodProducto;

		begin
         ClrScr;
			for Producto := 1 to 100 do
				ArrayProductos[ Producto ].Precio := -1;
          write ( 'Proceso de inicializacin concluido.' );
        
         write ( 'Pulse <CUALQUIER TECLA> para continuar . . . ' );
         readln;
		end;


	{ Procedimiento que carga en el array " AProductos " la informacin
     contenida en el fichero de productos " Almacen.dat ". }

procedure CargarMemoria ( var AProductos: TAProductos;var FAlmacen: TFAlmacen );
      var
         Registro:   TProducto;
         FinFichero: Boolean;


      { Procedimiento para leer secuencialmente los registros del fichero
        FAlmacen, de tipo TFAlmacen. }

    procedure LeerFichero ( var Fichero: TFAlmacen;var RegFichero: TProducto; var FF: Boolean );
         begin
            if EOF ( Fichero ) then
              FF := True
            else
              Read ( Fichero, RegFichero );
         end;

		begin   { CargarMemoria }
        ClrScr;
        Assign ( FAlmacen, 'Almacen.dat' );
        Reset ( FAlmacen );
        FinFichero := False;
        LeerFichero ( FAlmacen, Registro, FinFichero );
        while not FinFichero do begin
           AProductos[ Registro.CodProducto ] := Registro;
           LeerFichero ( FAlmacen, Registro, FinFichero );
        end;
        Close ( FAlmacen );
        Gotoxy ( 18, 12 ); write ( 'Proceso de carga concluido.' );
        Gotoxy ( 18, 14 );
        write ( 'Pulse <CUALQUIER TECLA> para continuar . . . ' );
        readln;
      end;    { CargarMemoria }


   { Procedimiento que lee cada pedido del fichero de pedidos, y que lo
     acepta si la cantidad que queda en el almacen respeta el mnimo
     permitido. Hace dos tratamientos diferentes dependiendo del tipo de
     pedido : aceptado o rechazado. }

   procedure TratarPedidos ( var AProductos: TAProductos;
                             var FPedidos: TFPedidos;
                             var FClientes: TFClientes );
      var
         Resto:      Integer;
         Pedido:     TPedido;
         Product:    Integer;
         FinFichero: Boolean;
         Seleccion:  Char;


      { Procedimiento para leer secuencialmente los registros del fichero
        FPedidos, de tipo TFPedido. }

      procedure LeerFichero ( var Fichero: TFPedidos; var RegFichero: TPedido;
                              var FF: Boolean );
         begin
            if EOF ( Fichero ) then
              FF := True
            else
              Read ( Fichero, RegFichero );
         end;


      { Procedimiento que trata los pedidos aceptados actualizando la
        cantidad de producto en la estructura de memoria, y generando
        una factura del pedido aceptado. }

      procedure Aceptado ( var AProductos: TAProductos; Pedido: TPedido;
                           var FClientes: TFClientes; Resto: integer );
         var
            Productos: TProducto;
            Cliente:   TCliente;

         begin   { Aceptado }
            ClrScr;
            AProductos[ Pedido.CodProducto ].Cantidad := Resto;
            seek ( FClientes, Pedido.CodCliente - 1 );
            read ( FClientes, Cliente );
            with Cliente do begin
              writeln;
              writeln ( '',
                        'ͻ' );
              write ( ' Cliente : ', NomCliente:13, 'RefCliente : ':22,
                        RefCliente:15 );
              Gotoxy ( 65, 3 ); writeln ( '' );
              writeln ( '',
                        '͹' );
              write ( ' Direccion :           c\ ', Direccion.Calle,
                      '.  ', Direccion.Ciudad, '.  (', Direccion.Provincia,
                      ').' );
              Gotoxy ( 65, 5 ); writeln ( '' );
              writeln ( '',
                        '͹' );
            end;    { with 'Cliente' }
            Productos := AProductos [ Pedido.CodProducto ];
            with Productos do begin
              write ( ' Producto : ', NomProducto:11 );
              Gotoxy ( 34, 7 ); write ( 'RefProducto : ', RefProducto:10 );
              Gotoxy ( 65, 7 ); writeln ( '' );
              write ( '' );
              Gotoxy ( 65, 8 ); writeln ( '' );
              write ( '   Cantidad ' );
              Gotoxy ( 30, 9 ); write ( 'Precio' );
              Gotoxy ( 54, 9 ); write ( 'Total');
              Gotoxy ( 65, 9 ); writeln ( '' );
              write ( '      ', Pedido.Cantidad );
              Gotoxy ( 21, 10 ); write ( '*' );
              Gotoxy ( 32, 10 ); write ( Precio );
              Gotoxy ( 45, 10 ); write ( '=' );
              Gotoxy ( 55, 10 ); write ( Pedido.Cantidad * Precio );
              Gotoxy ( 65, 10 ); writeln ( '' );
              writeln ( '',
                        'ͼ' );
            end;   { with 'Producto' }
            writeln; writeln;
            write ( 'Pulse <CUALQUIER TECLA> para continuar . . . ' );
            readln;
         end;    { Aceptado }


      { Procedimiento que trata los pedidos rechazados generando un
        impreso, y envindolos a pantalla o a impresora segn decida
        el usuario. }

      procedure Rechazado ( var AProductos: TAProductos; Pedido: TPedido;
                            var FClientes: TFClientes; var fichero: Text );
         var
            Cliente:  TCliente;
            Producto: string[ 11 ];

         begin   { Rechazado }
            ClrScr;
            seek ( FClientes, Pedido.CodCliente - 1 );
            read ( FClientes, Cliente );
            with Cliente do begin
                writeln;
                writeln ( fichero, '',
                               'ͻ' );
                write ( fichero, ' Cliente : ', NomCliente:13,
                             'RefCliente : ':22, RefCliente:15 );
                writeln ( fichero, '  ' );
                writeln ( fichero, '',
                               '͹' );
                if ( Pedido.CodCliente < 10 ) then begin
                  write ( fichero, ' Direccion :             C\ ',
                            Direccion.Calle, '.  ', Direccion.Ciudad, '.  (',
                            Direccion.Provincia, ').' );
                  Gotoxy ( 65, 5 ); writeln ( fichero, '   ' );
                end
                else begin
                  write ( fichero, ' Direccion :             C\ ',
                             Direccion.Calle, '. ', Direccion.Ciudad, '. (',
                             Direccion.Provincia, ').' );
                  Gotoxy ( 65, 5 ); writeln ( fichero, '   ' );
                end;  { if }
            end;    { with 'Cliente' }
            Producto := AProductos[ Pedido.CodProducto ].NomProducto;
            writeln ( fichero, '',
                           '͹' );
            write ( fichero, ' Lamentamos no poder atender su solicitud ',
                           'de   ', Producto );
            writeln ( fichero, '    ' );
            writeln ( fichero, ' por no poseer la cantidad de gnero ',
                           'requerida. Lamentamos las ' );
            writeln ( fichero, ' molestias, y le agradeceramos que ',
                           'volviese a cursar su       ' );
            writeln ( fichero, ' solicitud dentro de unos das.', '':33 );
            writeln ( fichero, '', '':64 );
            writeln ( fichero, ' Atentamente : XXXXX   Director comercial ',
                           'de la empresa.       ' );
            writeln ( fichero, '',
                           'ͼ' );
            writeln; writeln;
            write ( 'Pulse <CUALQUIER TECLA> para continuar . . . ' );
            readln;
         end;    { Rechazado }

      begin     { TratarPedidos }
         repeat
            ClrScr;
            writeln ( 'Direccin de los pedidos rechazados : ' );
            writeln ( '' );
            writeln;
            writeln ( '  1.- Pantalla' );
            writeln ( '  2.- Impresora' );
            writeln; writeln;
            write ( 'Seleccin : ' );
            Seleccion := readkey;
         until ( (Seleccion = '1') or (Seleccion = '2') );
         Assign ( FPedidos, 'Pedidos.dat' );
         Assign ( FClientes, 'Clientes.dat' );
         FinFichero := False;
         Reset ( FPedidos );
         Reset ( FClientes );
         LeerFichero ( FPedidos, Pedido, FinFichero );
         while not FinFichero do begin
              if ( Pedido.CodProducto >= 1 ) and
                ( Pedido.CodProducto <= 100 ) then begin
                   Resto := AProductos[ Pedido.CodProducto ].Cantidad - Pedido.Cantidad;
                   if ( Resto >= AProductos[ Pedido.CodProducto ].Minimo ) then
                     Aceptado ( Aproductos, Pedido, FClientes, Resto )
                   else
                     if ( Seleccion = '1' ) then
                       Rechazado ( AProductos, Pedido, FClientes, output )
                     else
                       Rechazado ( AProductos, Pedido, FClientes, Lst );
              end;   { if }
              LeerFichero ( FPedidos, Pedido, FinFichero );
         end;   { while }
         Close ( FClientes );
         Close ( FPedidos );
      end;     { TratarPedidos }


   { Procedimiento que realiza el aprovisionamiento de todos aquellos
     productos que se encuentran en mnimo en el almacen, mediante un
     impreso que ser enviado a los proveedores y que se almacenar en
     un fichero de texto " Aprovisi.TXT ". }

   procedure Aprovisionamiento ( var AProductos: TAProductos );

      var
         Texto:  Text;
         Indice: TCodProducto;
         Provee: TProducto;

      begin
         ClrScr;
         Assign ( Texto, 'Aprovisi.txt' );
         Rewrite ( Texto );
         for Indice := 1 to 100 do begin
            Provee := AProductos[ Indice ];
            if ( Provee.Precio <> -1 ) and
               ( Provee.Cantidad = Provee.Minimo ) then begin
               with Provee do begin
                 writeln ( Texto, '',
                                  'ͻ' );
                 write ( Texto, ' Proveedor : ', Proveedor:30 );
                 writeln ( Texto, '':21 );
                 writeln ( Texto, '',
                                  '͹' );
                 write ( Texto, ' Direccion :             C\ ',
                             Direccion.Calle, '.  ', Direccion.Calle, '.  (',
                             Direccion.Provincia, ').' );
                 writeln ( Texto, '':3 );
                 writeln ( Texto, '',
                                  '͹' );
                 write ( Texto, ' Solicitud de envo del producto : ',
                                NomProducto:12 );
                 writeln ( Texto, '':17 );
                 writeln ( Texto, '', '':64 );
                 writeln ( Texto, ' Se solicita el envo con caracter de ',
                                  'urgencia del producto    ' );
                 writeln ( Texto, ' arriba especificado en la cantidad ',
                                  'normalmente convenida.     ' );
                 writeln ( Texto, '', '':64 );
                 writeln ( Texto, ' Atentamente : XXXXX   Director comercial ',
                                  'de la empresa.       ' );
                 writeln ( Texto, '',
                                  'ͼ' );
                 writeln ( Texto, CHR ( 12 ) );
               end;    { with 'Provee' }
            end;  { if }
         end;  { for }
         Close ( Texto );
         Gotoxy ( 18, 12 ); write ( 'Proceso de aprovisionamiento concluido.' );
         Gotoxy ( 18, 14 );
         write ( 'Pulse <CUALQUIER TECLA> para continuar . . . ' );
         readln;
      end;


   { Procedimiento que actualiza el fichero FAlmacen ( 'Almacen.dat' ) y lo
     ordena por cdigo de producto. }

   procedure Actualizar ( var AProductos: TAProductos;
                          var FAlmacen: TFAlmacen );
      var
         I: TCodProducto;

      begin
         ClrScr;
         Assign ( FAlmacen, 'Almacen.dat' );
         Rewrite ( FAlmacen );
         for I := 1 to 100 do
             if ( AProductos [ I ].Precio <> -1 ) do begin
                write ( FAlmacen, AProductos[ I ] );
         Close ( FAlmacen );
         Gotoxy ( 18, 12 ); write ( 'Proceso de actualizacin concluido.' );
         Gotoxy ( 18, 14 );
         write ( 'Pulse <CUALQUIER TECLA> para continuar . . . ' );
         readln;
      end;
    end;

   begin  { Programa principal }
		InicializarMemoria ( AProductos );
		CargarMemoria ( AProductos, FAlmacen );
		TratarPedidos ( AProductos, FPedidos, FClientes );
      Aprovisionamiento ( AProductos );
      Actualizar ( AProductos, FAlmacen );
   end.   { Programa principal }