{ Este lindo progama arma una barra de menues descolgables en modo texto
 a partir de un archivo de configuracin externo en texto ASCII el cual
 tiene un formato definido para hacerlo (leer documentacin).
  Autor: Diego F. Romero
 E-Mail: diegofrom@yahoo.com
 (nota: se espera Turbo Pascal 7.0 para compilarlo) }

uses crt,lista1;
type
 tpos=record     { Posicin de la pantalla }
      car:char;
     attr:byte;
    end;

    tlinea=array [1..80] of tpos;   { Linea de la Pantalla }
     tpant=array [1..25] of tlinea; { Pantalla Entera }


var
a,pcod,scod:char;                     { Para recibir los codigos de tecla }
mnuactual:tpuntero;                   { Puntero al menu actual }
pant:tpant absolute $b800:$0000;      { Pantalla }
bkpant:tpant;                         { Para guardar temporalmente la pantalla }

procedure Cargar_menu(archivo:string);
{ Lee el archivo de configuracin y arma los menues en memoria }
var
f:text;         { Archivo }
s:string;       { Linea del Archivo }
d:tdato;        { un nodo de la lista }
a:tpuntero;     { Puntero al nodo }
proxx:byte;     { para calcular dinamicamente la columna de cada men }
begin
a:=nil;
s:='';
proxx:=2;
assign(f,archivo);            { Abro el archivo }
reset(f);                     {  Debe existir ! }
repeat
readln(f,s);                  { Leo una linea }
  begin
     if pos('.',s)=1 then             { (1) Es una opcin... }
        begin
           delete(s,1,1);             { Quito el punto }
           with d do                  { con el nodo actual... }
              begin                   { cargo sus valores }
                 inc(cantopciones);             { Sumo uno a la cantidad de opciones de este descolgable }
                 opcion[cantopciones]:=s;       { Cargo el nombre de la opcin }
                 if length(opcion[cantopciones]) > mnuancho then
                          mnuancho:=length(opcion[cantopciones]); { Calculo el ancho del men }
                 mnualto:=cantopciones;         { Calculo el alto del men }
                 activo:=1;                     { La primera opcin es por omisin }
                 a^.dato:=d;                    { copio la info a la lista }
              end {with}
        end {then}
     else                            { (1) ...sino, es un titulo, por lo tanto un nuevo descolgable }
        begin
           with d do
              begin
                 posx:=proxx;       { establezco en que columna se pondr este descolgable }
                 posy:=1;           { la fila es la primera por omisin }
                 mnuancho:=0;       { vacio la dems info }
                 mnualto:=0;
                 activo:=0;
                 cantopciones:=0;
                 titulo:=s;         { Cargo el titulo... }
                 hotkey:=s[1];      { ...la tecla rapida... }
                 proxx:=proxx+length(s)+1;  { ... y calculo la columna del proximo descolgable }
              end; {With}
           a:=poner_en_lista(primero,ultimo,d); { agrego a la lista este nuevo descolgable }
        end; {Else}
  end; {Repeat}
until eof(f);   { Hasta el final del archivo }
end;

procedure dibujar_menu;
{ Dibuja la Barra con los titulos de cada descolgable }
var
a:tpuntero;
i:byte;
txactual:byte;
begin
txactual:=textattr;                { Guardo los atributos de texto actuales }
textbackground(7);                 { Establezco un nuevo color de fondo... }
textcolor(0);                      { ... y del texto }
for i:=1 to 80 do                  { Dibujo la barra }
  begin
     gotoxy(i,1);
     writeln(#32);
  end;
a:=primero;                        { Empiezo por el primero }
while a<>nil do                    { Mientras haya un siguiente hago }
   begin
      with a^.dato do              { Con la info del nodo actual... }
         begin
            textcolor(0);          { Pongo el titulo }
            gotoxy(posx,posy);
            write(titulo);
            textcolor(1);
            gotoxy(posx,posy);     { la tecla rpida }
            write(hotkey);
         end;{With}
        a:=siguiente(a);           { y paso al siguiente nodo }
     end;{While}
textattr:=txactual;                { Reestablezco los atributos del texto }
end;

procedure writechar(C: char); assembler;
{ Imprimo un caracter en la pantalla - rpido }
{ Cuidado!!!, este procedimiento DESTRUYE el stack si C:=''}
asm
        mov     ah, 0Eh
        mov     al, C
        xor     bh, bh
        mov     bl, 07h
        int     10h
end;

procedure ponerenxy(x,y:byte;a:char);
{ Pone un caracter en la pantalla de forma absoluta }
begin
gotoxy(x,y);
writechar(a);
end;

procedure ponercenxy(x,y:byte;a:char);
{ Pone un caracter en la pantalla relativo a la ventana }
begin
gotoxy(x,y);
write(a);
end;


procedure recuadro(x1,y1,x2,y2:byte);
{ Dibuja el recuadro del descolgable }
var
i:byte;
begin
ponerenxy(x1,y1,#218);             { Dibujo las esquinas }
ponerenxy(x2,y1,#191);
ponerenxy(x1,y2,#192);
ponerenxy(x2,y2,#217);
ponerenxy(x1+1,y1,#217);           { Dibujo los enlaces }
ponerenxy(x1+2,y1,#192);
for i:=x1+3 to x2-1 do ponerenxy(i,y1,#196);  { El borde superior sin sobreescribir el enlace }
for i:=x1+1 to x2-1 do ponerenxy(i,y2,#196);  { El borde inferior }
for i:=y1+1 to y2-1 do                        { Ambos lados a la vez }
   begin
      ponerenxy(x1,i,#179);
      ponerenxy(x2,i,#179);
   end;
end;

procedure ponersep(x,y,l:byte);
{ Dibuja un separador inactivo (@) }
var
i:byte;
begin
for i:=x to l do ponerenxy(i,y,'');
end;

procedure controlar_rango(var a:integer;max:byte);
{ Verifica que la barra de seleccin no se pase de rango }
begin
if a > max then a:=1;
if a < 1 then a:=max;
end;

procedure Poner_menu(var a:tdato;var pcod,scod:char);
{ Dibuja un descolgable - toma el control del teclado }
var
i,j:byte;
begin
pcod:=#0;
scod:=#0;
with a do
   begin
      textbackground(0);      { Cambio el color al titulo }
      textcolor(7);
      gotoxy(posx,posy);
      write(titulo);
      textcolor(15);
      gotoxy(posx,posy);
      write(hotkey);
      window(posx+1,posy+2,posx+2+mnuancho,posy+3+mnualto); { Sombra }
      textbackground(0);                                    { Negra }
      clrscr;
      window(posx-1,posy+1,posx+mnuancho,posy+mnualto+2);   { Cuadro }
      textbackground(7);                                    { Blancogris}
      textcolor(0);
      clrscr;
      recuadro(1,1,mnuancho+2,mnualto+2);                   { Dibujo el Recuador }
      textbackground(7);
      textcolor(0);
      for i:=1 to cantopciones do                           { Pongo las opciones para este descolgable }
         begin
            if opcion[i] = '@' then ponersep(2,i+1,mnuancho+1) { Si es un separador lo dibujo... }
            else                                               { ...si no, pongo la opcin }
               begin
                  gotoxy(2,i+1);
                  write(opcion[i]);
              end;
         end;

      repeat
      textbackground(0);                { Activo la barra de seleccin }
      textcolor(7);
      for j:=2 to mnuancho+1 do ponercenxy(j,activo+1,#32);
      gotoxy(2,activo+1);
      write(opcion[activo]);

      scod:=#0;
      pcod:=upcase(readkey);            { Espero al usuario }

      textbackground(7);                { Desactivo la barra }
      textcolor(0);
      for j:=2 to mnuancho+1 do ponercenxy(j,activo+1,#32);
      gotoxy(2,activo+1);
      write(opcion[activo]);

      if pcod=#0 then                  { Controlo la Tecla presionada  - Si es una tecla especial... }
         begin
            scod:=readkey;             { ...guardo el segundo codigo... }
            case scod of
              #72:dec(activo);         { ...es Flecha Arriba }
              #80:inc(activo);         { ...es Flecha Abajo }
            end;
            controlar_rango(activo,cantopciones);   { Controlo el rango }
            if opcion[activo] = '@' then            { Si es un separador... }
               begin                                { ... lo salteo }
                  if scod = #72 then dec(activo)
                  else inc(activo);
                  controlar_rango(activo,cantopciones);
               end;
         end;
      until (scod<>#72) and (scod<>#80);            { Sale si la tecla presionada no es Flecha Arriba o Abajo }
   end;{With}
window(1, 1, 80, 25);                   { Desactivo la ventana }
end;{Poner_menu}

begin
{ Pincipal }
textbackground(1);                             { Pantalla en Azul }
clrscr;
Cargar_menu('menu.txt');                       { Cargo los menues desde el archivo de configuracin }
Dibujar_menu;                                  { Dibujo la barra }
mnuactual:=primero;                            { Establezco el primer descolgable }
bkpant:=pant;                                  { Guardo la pantalla en memoria }
repeat
poner_menu(mnuactual^.dato,pcod,scod);         { Dibujo el descolgable actual }
pant:=bkpant;                                  { al salir reestablezco la pantalla guardada }
if pcod=#0 then                                { Si la tecla de salida es una especial...}
   begin
      case scod of                             { ... me fijo cual es }
        #77:begin                              { Flecha derecha }
               mnuactual:=siguiente(mnuactual);
               if mnuactual=nil then mnuactual:=primero;
            end;
        #75:begin                              { Flecha izquierda }
               mnuactual:=anterior(mnuactual);
               if mnuactual=nil then mnuactual:=ultimo;
            end;
      end; {Case}
   end;{if}
if pcod=#13 then                                { Si es ENTER ejecuto... }
   begin
      textcolor(7);                             { ...lo que sea que haya que ejecutar }
      textbackground(1);
      gotoxy(15,15);
      write('Ejecutando ',mnuactual^.dato.titulo,'>',mnuactual^.dato.opcion[mnuactual^.dato.activo]);
   end;
until pcod=#27;                                 { Hasta que la tecla sea Escape }
textcolor(7);
end.