{ Esto es solo un ejemplo de una biblioteca de procedimientos y funciones
para armar una Lista con Punteros Doblemente enlazada.
Se deber cambiar la declaracin del registro asociado a la Lista}

unit lista1;

interface
type
      tarraydeopciones=array[1..12] of String;    { Doce opciones en cada descolgable }
      tdato=record                                { Datos del descolgable }
           posx:byte;               { Columna }
           posy:byte;               { Fila }
       mnuancho:byte;               { Ancho }
        mnualto:byte;               { Alto }
         titulo:string;             { Titulo que aparece en la barra }
         hotkey:char;               { Tecla rpida }
         opcion:tarraydeopciones;   { Opciones }
   cantopciones:byte;               { Cantidad de opciones }
         activo:integer;            { Opcin activa }
         end;

   tpuntero=^treg;                  { Puntero al nodo }

   treg=record                      { Nodo }
     dato:tdato;
     sig:tpuntero;
     ant:tpuntero;
     end;
var
primero,ultimo:tpuntero;                                      { Punteros al primer y ultimo nodo de la lista }

function Poner_en_lista(var p,u:tpuntero; d:tdato):tpuntero;
function Buscar_en_Lista(p:tpuntero;d:char):tpuntero;
function Siguiente(p:tpuntero):tpuntero;
function Anterior(p:tpuntero):tpuntero;


implementation

{ Crea la lista vacia }
procedure crear_lista(var p,u:tpuntero);
begin
p:=nil;
u:=nil;
end;

{Pone un nuevo nodo al final de la lista
Parametros:
  p=Apunta al Primero de la Lista
  u=Apunta al ltimo de la Lista
  d=Dato a almacenar en el nuevo nodo de la lista
  devuelve un puntero al nodo creado}
function poner_en_lista(var p,u:tpuntero; d:tdato):tpuntero;
var
 aux:tpuntero;
begin
new(aux);       { Se crea el nuevo nodo }
aux^.dato:=d;
aux^.sig:=nil;  { El enlace al siguente nodo debe apuntar a nada }
aux^.ant:=nil;
if p = nil then    { Si la Lista est Vacia... }
   begin
      p:=aux;      { El puntero al primer nodo y al ltimo nodo... }
      u:=aux;      { ...apuntan al nico nodo en la lista }
   end
   else
   begin
      u^.sig:=aux; { el ltimo nodo debe apuntar al nuevo nodo y... }
      aux^.ant:=u;
      u:=aux;      { ...el puntero al ltimo nodo debe apuntar al nuevo ltimo }
   end;
poner_en_lista:=aux; { Devuelvo el nuevo nodo }
end;

{ Devuelve un puntero al siguiente nodo apuntado por p }
function siguiente(p:tpuntero):tpuntero;
begin
siguiente:=p^.sig;
end;

{ Devuelve un puntero al nodo anterior apuntado por p }
function anterior(p:tpuntero):tpuntero;
begin
anterior:=p^.ant;
end;

{Busca un elemento que contenga el dato buscado
Parametros:
     p=puntero al primero de la lista.
     d=dato buscado.
Nota: devuelve un puntero al nodo que contiene el mismo dato que
      se busca o nil si no lo encuentra.
      No usado, puesto a modo de ejemplo. }
function Buscar_en_Lista(p:tpuntero;d:char):tpuntero;
begin
while (p<> nil) and (p^.dato.hotkey <> d) do {Mientras haya mas nodos y
                                       no se encuentra el dato buscado...}
     begin
        p:=p^.sig; {...sigo buscando}
     end;
Buscar_en_Lista:=p; {Devuelvo el nodo encontrado (o nil)}
end;

begin
{ Primero que nada creo la lista }
crear_lista(primero,ultimo);
end.