Program memoria;
Uses crt;
Type
  datos = record
          Nombre: string [40];
          Apodo: string [10];
          Mail: string [30];
          Telefono: string [20];
          activo: boolean;
         end;

  agenda = file of datos;
Var
  archivo: agenda;

Procedure pulsar;
begin
  writeln;
  textcolor (9);
  write ('');
  textcolor (11);
  write ('Presione <ENTER> para continuar');
  readln;
end;

Procedure cuadro;
  procedure arriba;
  var
    i: byte;
  begin
    gotoxy (1,1);
    for i:= 1 to 80 do begin
      gotoxy (i,1);
      delay (5);
      write ('');
    end
  end; {arriba}
  Procedure derecha;
  var i: byte;
  begin
    gotoxy (80,1);
    for i:= 1 to 24 do begin
      gotoxy (80,i);
      delay (9);
      write ('');
    end
  end; {Derecha}
  Procedure abajo;
  var i: byte;
  begin
    gotoxy (80,25);
    for i:= 80 downto 1 do begin
      gotoxy (i,24);
      delay (5);
      write ('');
    end
  end; {Abajo}
  Procedure izquierda;
  var i: byte;
  begin
    gotoxy (1,25);
    for i:= 24 downto 1 do begin
      gotoxy (1,i);
      delay (9);
      write ('');
    end
  end; {izquierda}
Begin {Principal de cuadro}
  textcolor (1);
  arriba;
  derecha;
  abajo;
  izquierda;
end; {Cuadro}



Procedure Fondo;
var
  i,j: byte;
begin
  for i:= 1 to 26 do
    for j:= 1 to 80 do begin
      gotoxy (j,i);
      textcolor (9);
      write ('');
     end
end;

Procedure activar (var f: agenda);
var
  resultado: integer;
begin
  {$I-}
  reset (f);
  resultado:= IOresult;
  {$I+}
  if resultado <> 0 then
    rewrite (f);
  close (f);
end; {activar}

Function Posicion (n: string; var f: agenda): integer;
var
  registro: datos;
  hallado: boolean;
begin
  hallado:= false;
  seek (f,0);
  while not eof(f) and not hallado do begin
    read (f,registro);
    hallado:= registro.apodo = n
  end;
  if hallado then
    posicion:= filepos(f) - 1
  else
    posicion:= -1;
end;  {Posicion}

Procedure Visualizar (E: datos);
begin
  fondo;
  textcolor (11);
  with e do begin
    if E.activo then begin
      gotoxy (28,6);
      writeln (nombre);
      writeln;
      gotoxy (28,9);
      writeln (mail);
      writeln;
      gotoxy (28,12);
      writeln (telefono);
      writeln;
    end;
  end;
  pulsar;
end;  {Visualizar}

Procedure LeerRegistro (var E: datos);
var
  i: byte;
begin
  textcolor (11);
  with E do begin
    gotoxy (3,9);
    write ('Nombre  ==> ');
    readln (nombre);
    for i:= 1 to length (nombre) do
      nombre[i]:= upcase (nombre[i]);
    writeln;
    gotoxy (3,11);
    write ('Conocido como  ==> ');
    readln (apodo);
    for i:= 1 to length (apodo) do
      apodo[i]:= upcase (apodo[i]);
    gotoxy (3,12);
    writeln ('Recuerde que el nombre que acaba de escribir, es el que introducira');
    gotoxy (3,13);
    writeln ('cuando quiera buscar, modificar o eliminar a un contacto de la agenda');
    writeln;
    gotoxy (3,15);
    write ('Mail  ==> ');
    readln (mail);
    writeln;
    gotoxy (3,17);
    write ('Telefono  ==> ');
    readln (Telefono);
    activo:= true;
  end;
  writeln;
end;  {Leer Registro}

Procedure ampliar (var F: agenda);
var
  r,e: datos;
  i: integer;   {Posicion del registro del archivo}
begin
  clrscr;
  fondo;
  gotoxy (11,3);
  textcolor (19);
  write ('***************************************************************');
  textcolor (11);
  gotoxy (35,3);
  writeln ('ZONA DE ALTAS');
  reset (f);
  writeln;
  textcolor (9);
  write ('');
  textcolor (11);
  writeln('Pulse cualquier letra menos la "n" o la "N"');
  while upcase (readkey) <> 'N' do begin
    clrscr;
    fondo;
    gotoxy (35,3);
    textcolor (11);
    writeln (' ZONA DE ALTAS ');
    writeln;
    writeln;
    gotoxy (3,6);
    writeln ('Introduzca los datos del nuevo contacto');
    leerregistro (E);
    I:= Posicion (E.apodo, F);
    if I = -1 then begin
      i:= filesize (f);
      seek (f, I);
      write (F, E);
      end
    else  begin
      seek (F, I);
      read (F, R);
      if  R.activo then begin
        textcolor (9);
        write ('');
        textcolor (11);
        writeln ('Ya existe una persona con ese nombre');
        writeln;
        pulsar;
      end
      else
        write (F, E);
    end;
    textcolor (9);
    write ('');
    textcolor (11);
    writeln ('Pulse "N" si quiere salir de la zona de altas');
  end;
  close (F);
end;  {Ampliar}

Procedure Borrar (var F: agenda);
var
  E: datos;
  N: string;
  I: Integer;
begin
  reset (F);
  repeat
    clrscr;
    fondo;
    gotoxy (11,3);
    textcolor (19);
    write ('***************************************************************');
    textcolor (11);
    gotoxy (35,3);
    writeln ('ZONA DE BAJAS');
    reset (F);
    writeln;
    writeln;
    textcolor (9);
    gotoxy (1,6);
    write ('');
    textcolor (11);
    write ('Introduce el apodo de la persona a borrar  ==> ');
    readln (N);
    for i:= 1 to length (n) do
      n[i]:= upcase (n[i]);
    I:= Posicion (N, F);
    if I = -1 then begin
      textcolor (9);
      write ('');
      textcolor (11);
      writeln ('No se encuentra en la base de datos');
      pulsar;
    end
    else begin
      seek (F, I);
      read (F, E);
      if E.activo then begin
        visualizar (E);
        E.activo:= false;
        I:= Filepos (F) - 1;
        seek (F, I);
        write (F, E);
      end;
      writeln;
      textcolor (9);
      gotoxy (1,6);
      write ('');
      textcolor (11);
      writeln ('El registro fue dado de baja');
      writeln;
      pulsar;
    end;
    writeln;
    textcolor (9);
    write ('');
    textcolor (11);
    writeln ('Pulse "N" para salir de la zona de bajas');
  until upcase (readkey) = 'N';
  close (f);
end;  {Borrar}


Procedure Modificar (var F: agenda);
var
  E: datos;
  N: string;
  I: integer;
begin
  reset (F);
  repeat
    clrscr;
    fondo;
    gotoxy (11,3);
    textcolor (19);
    write ('***************************************************************');
    textcolor (11);
    gotoxy (35,3);
    writeln ('ZONA DE MODIFICACIONES');
    writeln;
    textcolor (9);
    gotoxy (1,7);
    write ('');
    textcolor (11);
    write ('Introduce el apodo de la persona  ==> ');
    readln (n);
    for i:= 1 to length (n) do
      n[i]:= upcase (n[i]);
    I:= Posicion (N, F);
    if I = -1 then begin
      textcolor (9);
      write ('');
      textcolor (11);
      write ('No existe esa persona en la base de datos');
      pulsar;
    end
    else begin
      seek (F, I);
      read (F, E);
      if E.activo then begin
        clrscr;
        fondo;
        visualizar (E);
        writeln;
        clrscr;
        fondo;
        gotoxy (1,4);
        textcolor (9);
        write ('');
        textcolor (11);
        writeln ('Introduce los nuevos datos de esta persona');
        LeerRegistro (E);
        I:= Filepos (f) - 1;
        seek (F, I);
        write (F, E);
        writeln;
        textcolor (9);
        write ('');
        textcolor (11);
        writeln ('Registro modificado');
      end
      else begin
        writeln;
        textcolor (9);
        write ('');
        textcolor (11);
        writeln ('El registro fue dado de baja');
      end
    end;
    writeln;
    textcolor (9);
    write ('');
    textcolor (11);
    writeln ('Pulse "N" para salir de la zona de modificaciones');
  until upcase (readkey) = 'N';
  close (F);
end;  {Modificar}

Procedure Consultar (var F: agenda);
var
  E: datos;
  N: string;
  I: Integer;
begin
  reset (F);
  repeat
    clrscr;
    fondo;
    gotoxy (11,3);
    textcolor (19);
    write ('***************************************************************');
    textcolor (11);
    gotoxy (35,3);
    writeln ('ZONA DE CONSULTAS');
    writeln;
    textcolor (9);
    gotoxy (1,6);
    write ('');
    textcolor (11);
    write ('Introduce el nombre del estudiante a consultar  ==> ');
    readln (N);
    for i:= 1 to length (n) do
      n[i]:= upcase (n[i]);
    I:= Posicion (N, F);
    if I = -1 then begin
      textcolor (9);
      write ('');
      textcolor (11);
      writeln ('No existe esa persona en la base de datos');
      pulsar;
    end
    else begin
      seek (F, I);
      read (F, E);
      if E.activo then begin
        clrscr;
        visualizar (E);
      end
      else begin
        writeln;
        textcolor (9);
        write ('');
        textcolor (11);
        writeln ('El registro fue dado de baja');
        writeln;
        pulsar;
      end
    end;
    textcolor (9);
    write ('');
    textcolor (11);
    writeln ('Pulse "N" si desea salir de la zona de consultas');
  until upcase (readkey) = 'N';
  close (F);
end;  {Modificar}

Procedure Menu (var f: agenda);
var
  opcion: char;
begin
  repeat
    clrscr;
    fondo;
    cuadro;
    textbackground (0);
    gotoxy (10,3);
    textcolor (19);
    delay (45);
    write ('**************************************************************');
    textcolor (11);
    gotoxy (33,3);
    textbackground (8);
    writeln (' MEN PRINCIPAL ');
    writeln;
    writeln;
    textcolor (11);
    writeln;
    gotoxy (3,6);
    delay (45);
    writeln ('1.- Agregar un contacto');
    writeln;
    gotoxy (3,8);
    delay (45);
    writeln ('2.- Modificar la informacion de un contacto');
    writeln;
    gotoxy (3,10);
    delay (45);
    writeln ('3.- Buscar un contacto');
    writeln;
    gotoxy (3,12);
    delay (45);
    writeln ('4.- Eliminar un contacto');
    writeln;
    gotoxy (3,14);
    delay (45);
    writeln ('5.- Salir');
    writeln;
    writeln;
    gotoxy (3,17);
    delay (45);
    write ('Escriba el numero de la opcion que desee  ==>  ');
    repeat
      opcion:= readkey
    until opcion in ['1'..'5'];
    clrscr;
    case opcion of
      '1': ampliar (F);
      '2': Modificar (F);
      '3': Consultar (F);
      '4': Borrar (f);
    end
  until opcion = '5';
end;  {Menu}

Begin  {Principal}
  clrscr;
  assign (archivo, 'c:contacto.dat');
  activar (archivo);
  menu (archivo);
End.

